using UnityEngine;
using UnityEngine.SceneManagement;
using UnityEngine.UI;

/*
 * Handler for Statistics UI
 */
public class StatsUIHandler : MonoBehaviour
{
    public Text correctNum;
    public Text incorrectNum;
    public Text guruNum;
    public Text powerNum;
    public Text compNum;
    public Text avgCompVal;
    public Text compImpVal;
    public Text prefAttachVal;

    // Start is called before the first frame update, Displays some setting and statistics from the simulation that was just completed
    void Start()
    {
        correctNum.text = StatsManager.instance.correct.ToString();
        incorrectNum.text = StatsManager.instance.incorrect.ToString();

        guruNum.text = (StatsManager.instance.numGurusTotal / StatsManager.instance.numRounds).ToString();
        powerNum.text = (StatsManager.instance.highestPowerTotal / StatsManager.instance.numRounds).ToString();
        compNum.text = (StatsManager.instance.avgCompetenceTotal / StatsManager.instance.numRounds).ToString();

        switch (StatsManager.instance.compGain)
        {
            case 4.0f:
                avgCompVal.text = "Low";
                break;

            case 8.0f:
                avgCompVal.text = "Med";
                break;

            case 12.0f:
                avgCompVal.text = "High";
                break;
        }

        switch (StatsManager.instance.compImp)
        {
            case 0.0f:
                compImpVal.text = "None";
                break;

            case 0.5f:
                compImpVal.text = "Low";
                break;

            case 1.0f:
                compImpVal.text = "Med";
                break;

            case 2.0f:
                compImpVal.text = "High";
                break;
        }

        switch (StatsManager.instance.prefAttach)
        {
            case 0.0f:
                prefAttachVal.text = "None";
                break;

            case 0.5f:
                prefAttachVal.text = "Low";
                break;

            case 1.0f:
                prefAttachVal.text = "Med";
                break;

            case 2.0f:
                prefAttachVal.text = "High";
                break;
        }
    }

    // Loads the start menu scene when user presses back button
    public void Back()
    {
        SceneManager.LoadScene("MenuScene");
    }
}